CREATE TABLE Tab_Zonas_Localidades (
	Id_Zona_Loc   Int Identity(1,1) NOT NULL,
	Id_Zona       char(5) NOT NULL,
	Id_Localidad  Int,
	Id_Provincia  Char(3),
	Id_Pais       Char(3),
	CP            Char(10), 
	Descripcion   varchar(50),
	Coeficiente   Decimal(7,5),
	Importe       Decimal(12,2),
	Flag_Lunes    Tinyint,
    Flag_Martes    Tinyint,
	Flag_Miercoles Tinyint,
	Flag_Jueves   Tinyint,
	Flag_Viernes  Tinyint,
	Flag_Sabado   Tinyint,
	Nota          Text

 CONSTRAINT PK_TZLoc_PorZonaId PRIMARY KEY CLUSTERED (Id_Zona_Loc ASC,Id_Zona ASC) )
 GO

 ALTER TABLE Tab_Zonas_Localidades ADD CONSTRAINT FK_TZLoc_PorZonaId FOREIGN KEY (Id_Zona)
	   REFERENCES Tab_Zonas (Id_Zona)

 CREATE INDEX IX_TZLoc_Descrip ON Tab_Zonas_Localidades (Descripcion,Id_Zona,Id_Zona_Loc)

 CREATE INDEX IX_TZLoc_CP ON Tab_Zonas_Localidades (CP,Id_Zona,Id_Zona_Loc)

 CREATE INDEX IX_TZLoc_Local ON Tab_Zonas_Localidades (Id_pais,Id_Provincia,Id_Localidad,Id_Zona,Id_Zona_Loc)

 ALTER TABLE Tab_Zonas_Localidades ADD CONSTRAINT FK_TZLoc_Localidad FOREIGN KEY (Id_pais,Id_Provincia,Id_Localidad)
	   REFERENCES Tab_Localidades (Id_pais,Id_Provincia,Id_Localidad)



